public class primer1List 
{
    // pointers to the first and last node
    // first primer should be the most ideal one, i.e. 3'
    // position away from mismatch and with Tm closest to optimum Tm
    primer1Entry first = null;
    primer1Entry last = null;

    //number of primers in list
    int count = 0;

    public primer1List() {}

    //a method to insert a (new) primer
    public void insert (primer1Entry p1n)
    {
        //increment the count
        count++;

        if (first == null)
        {
            //empty list
            last = p1n;
            first = p1n;
        }
        else
        {
	    //first check how far away is the 3' position
	    //from the mismatch
            //second check how far away is the primer's Tm
            //from optimum melting temperature

            //starting from last pair is list
            primer1Entry temp = last;
            boolean OK = false;

            while (temp != null)
            {
		//if no mismatch introduced, the closer the 3' end of primer from snploc (misloc),
		//the better because after cutting there will be a manageable product size difference
		if (((p1n.snploc == p1n.misloc) && (p1n.difLoc > temp.difLoc)) ||
		    ((p1n.snploc != p1n.misloc) && (p1n.difLoc < temp.difLoc)) ||
		    ((p1n.difLoc == temp.difLoc) && (p1n.difTm > temp.difTm)))
                {
                    //insert after temp
                    p1n.next = temp.next;
                    p1n.prev = temp;

                    //special care for the "last"
                    if (temp == last)
                        last = p1n;
                    else
                        temp.next.prev = p1n;

                    temp.next = p1n;

                    //signal OK
                    OK = true;
                    break;
                }

                temp = temp.prev;
            } //end of while

            if (OK == false)
            {
                //must be an even better than the first in list 
                //insert before first
                p1n.next = first;
                first.prev = p1n;
                first = p1n;
            }
        } //end of else
    } //end of insert method

    //a method to get the first pair in list
    public primer1Entry get()
    {
        primer1Entry temp = first;

        if (count == 1)
        {
            first = null;
            last = null;
        }
        else
            first = first.next;

        count--;
        return temp;
    }

    //a method to check whether list is empty
    public boolean empty()
    {
	return count == 0;
    }
}
