import java.io.*;
import java.util.*;
import java.lang.Math.*;

public class outerPrimer extends Thread {
    private Lock1 lock2_1;
    private Lock1 lock2_3;
    private Lock1 lock4;
    private String sequence = "";        //source sequence
    private String allele1 = "";         //first allele in sequence
    private String allele2 = "";         //second allele in sequence
    private int sloc = 0;                //starting position of polymorphism in sequence
    private int optprimersize = 0;       //optimum primer size
    private int maxprimersize = 0;       //maximum primer size
    private int minprimersize = 0;       //minimum primer size
    private int optproductsize = 0;	 //optimum product size
    private int maxproductsize = 0;	 //maximum product size
    private int minproductsize = 0;	 //minimum product size
    private int optprimerTm = 0;         //optimum primer Tm
    private int maxprimerTm = 0;         //maximum primer Tm
    private int minprimerTm = 0;         //minimum primer Tm
    private double maxprimergc = 0;      //maximum primer GC%
    private double minprimergc = 0;      //minimum primer GC%
    private double maxprimercom = 0;     //maximum primer complementarity
    private double maxprimer3com = 0;    //maximum primer 3' complementarity
    private double saltconc = 0;         //salt (K+) concentration in mM
    private double primerconc = 0;       //primer concentration in nM
    private int numoutput = 0;           //number of outputs

    public outerPrimer (Lock1 l1, Lock1 l2, Lock1 l3, String s1, String s2, String s3, int loc, int optprisize, int maxprisize, int minprisize, int optprodsize, int maxprodsize, int minprodsize, int optpriTm, int maxpriTm, int minpriTm, double maxprigc, double minprigc, double maxpricom, double maxpri3com, double saltc, double primerc, int numout)
    {
        lock2_1 = l1;
        lock2_3 = l2;
        lock4 = l3;
        sequence = s1;
	allele1 = s2;
	allele2 = s3;
        sloc = loc;
        optprimersize = optprisize;
        maxprimersize = maxprisize;
        minprimersize = minprisize;
        optproductsize = optprodsize;
        maxproductsize = maxprodsize;
        minproductsize = minprodsize;
        optprimerTm = optpriTm;
        maxprimerTm = maxpriTm;
        minprimerTm = minpriTm;
        maxprimergc = maxprigc;
        minprimergc = minprigc;
        maxprimercom = maxpricom;
        maxprimer3com = maxpri3com;
        saltconc = saltc;
        primerconc = primerc;
        numoutput = numout;
    }

    public void run() {

        int stopcount = 0;
        int countout = 0;
	int idealcount = 0;	    //ideal primer count
        double delta_H = 0;
        double delta_S = 0;
        int tm = 0;
        int inner5 = 0;             //5' position of inner primer
        int inner3 = 0;             //3' position of inner primer
        int innerTm = 0;
        int allelep = 1;	    //1 indicates wild-type sequence, otherwise mutant sequence
	int lendif = 0;		    //length difference between wild-type and the present sequence
        double gc = 0;
        double valself = 0;
        double val3self = 0;
        double valbtw = 0;
        double val3btw = 0;
        String inString = "";
        String inner = "";
        boolean innerOK = false;
        boolean gcOK = false;
        boolean tmOK = false;
        boolean valOK = false;
        boolean val3OK = false;
        primerPairList ppl = new primerPairList();

        while (true)
        {
            inString = lock2_3.get();
            if (inString.equalsIgnoreCase("finish"))
	        break;
	    else if (inString.equalsIgnoreCase("break"))
	    {
		//print heading information
		if (ppl.empty() != true)
		{
		    System.out.println("PCR primers recommended");
		    String head1 = "5'";
		    String head2 = "Primer pair sequence";
		    String head3 = "3'";
		    String head4 = "Tm";
		    int padlen = inner.length() - head2.length();
		    String padding = "";
		    for (int i=0; i<padlen; i++) padding += " ";
		    System.out.println("\n" + head1 + "\t" + head2 + padding + "\t" + head3 + "\t\t" + head4 + "\n");
		}

		//print current results
		
		//work out the lendif first, which would be essential in case of mutant sequence
		if (allelep != 1)
		    lendif = allele1.length() - allele2.length();
                while ((ppl.empty() != true) && (stopcount < numoutput))
                {
                    primerPairEntry pairentry = ppl.get();
                    primerEntry entry1 = pairentry.pn1;
                    primerEntry entry2 = pairentry.pn2;
 
                    //print out primer sequences, positions in sequence and Tm(s)
		    String padding = "";
		    int padlen = 0;
		    if (entry1.entry.length() > entry2.entry.length())
		    {
			padlen = entry1.entry.length() - entry2.entry.length();
		        for (int i=0; i<padlen; i++) padding += " ";
                    	System.out.println((entry1.end5-lendif) + "\t" + entry1.entry + "\t" + (entry1.end3-lendif) + "\t\t" + entry1.tm);
         	    	System.out.println((entry2.end5-lendif) + "\t" + entry2.entry + padding + "\t" + (entry2.end3-lendif) + "\t\t" + entry2.tm);
		    }
		    else
		    {
			padlen = entry2.entry.length() - entry1.entry.length();
		        for (int i=0; i<padlen; i++) padding += " ";
                    	System.out.println((entry1.end5-lendif) + "\t" + entry1.entry + padding + "\t" + (entry1.end3-lendif) + "\t\t" + entry1.tm);
         	    	System.out.println((entry2.end5-lendif) + "\t" + entry2.entry + "\t" + (entry2.end3-lendif) + "\t\t" + entry2.tm);
		    }
		    System.out.println("");

         	    //increment the stopcount
	            stopcount++;
                }

		//if no result available, print out the reason
                if ((countout == 0) && (innerOK == true))
                {
	            System.out.println("No appropriate inner reverse primers found");
       		    if (gcOK == false)
	                System.out.println("Please reset GC content range");
       	            else if (tmOK == false)
              		System.out.println("Please reset Tm or GC content inputs");
	            else if ((valOK == false) && (val3OK == false))
	            { 
	                System.out.println("Please reset complementarity inputs and/or");
	                System.out.println("reset the Tm or GC content inputs");
	            }
	            else if (valOK == false)
	            {
	                System.out.println("Please reset the Maximum complementarity inputs");
	                System.out.println("and/or reset the Tm or GC content inputs");
	            }
	            else if (val3OK == false)
	            {
	                System.out.println("Please reset the 3' Maximum complementarity inputs");
	                System.out.println("and/or reset other inputs like Tm inputs");
	            }
	        }

		//time to reinitialize all revelant variables for next round
		ppl = new primerPairList();
		stopcount = 0;
		idealcount = 0;
		allelep = 1;
		lendif = 0;
		countout = 0;
		innerOK = false;
		gcOK = false;
		tmOK = false;
		valOK = false;
		val3OK = false;

		//give a signal saying the current round is finished
		lock2_1.put("break");
	    }
            //ignore if targets met
	    else if (idealcount < numoutput)
	    {
                StringTokenizer st = new StringTokenizer(inString);
                inner5 = Integer.valueOf(st.nextToken()).intValue(); 
                inner = st.nextToken(); 
                inner3 = Integer.valueOf(st.nextToken()).intValue(); 
                innerTm = Integer.valueOf(st.nextToken()).intValue();
                allelep = Integer.valueOf(st.nextToken()).intValue();

                innerOK = true;
 
	        //Total options for this primer are the result of primer size options "times"
                //product size options. Begin with primer size options because of the existence
                //of "optimum" size and its more narrowed range.
 
                //There are (maxprimersize-minprimersize+1) options in total
                int options1 = maxprimersize - minprimersize + 1;
                int count1 = options1;
                int primersize = 0;
                int prevprimsize = 0;    //primersize of previous round
                boolean OK = false;
 
                while (count1 != 0)
                {
                    if (count1 == options1)
                    {
                        //first choose optimum primer size to test
                        primersize = optprimersize;
                    }
                    else if ((options1 - count1) % 2 == 0)
                    {
                        //primer shorter than optimum length
                        primersize = optprimersize - (options1 - count1) / 2;
                    }
                    else
                    {
		        //primer longer than optimum length
                        primersize = optprimersize + (options1 - count1) / 2 + 1;
                    }
 
                    //check whether primersize out of range
                    if (primersize < minprimersize)
                        primersize = prevprimsize + 1;
                    else if (primersize > maxprimersize)
                        primersize = prevprimsize - 1;
 
                    if ((primersize < minprimersize) || (primersize > maxprimersize))
                        break;
 
                    prevprimsize = primersize;
 
                    //There are (maxproductsize-minproductsize) options in total
                    //product size range if the source sequence is longer enough,
                    //otherwise depends on the length of the source sequence.
 
                    int options2 = maxproductsize - minproductsize;
         	    if (inner5 < sloc)
		    {
                        if (options2 > (sequence.length()-inner5-minproductsize))
                            options2 = sequence.length()-inner5-minproductsize;
		    }
		    else
		    {
                        if (options2 > (inner5-minproductsize))
                            options2 = inner5-minproductsize;
		    }

                    int count2 = options2;
                    int productsize = 0;
                    int prevprodsize = 0;    //productsize of previous round
 
                    while (count2 != 0)
                    {
                        if (count2 == options2)
                        {
                            //start from optimum product size
                            productsize = optproductsize;
                        }
                        else if ((options2 - count2) % 2 == 0)
                        {
                            //product shorter than optimum length
                            productsize = optproductsize - (options2 - count2) / 2;
                        }
                        else
                        {
                            //product longer than optimum length
                            productsize = optproductsize + (options2 - count2) / 2 + 1;
                        }
 
                        //check whether productsize out of range
                        if (productsize < minproductsize)
                            productsize = prevprodsize + 1;
                        else if (productsize > maxproductsize)
                            productsize = prevprodsize - 1;
     	        	if ((productsize < minproductsize) || (productsize > maxproductsize))
                            break;
 
		        //design outer primer now
		        String outer = "";
		        int p1 = 0;
		        int p2 = 0;
 		        if (inner5 < sloc)
		        {
                            //check whether productsize out of source sequence range
                            if (productsize > sequence.length()-inner5)
                                break;
        		    else
			    {
                                //save current productsize
                                prevprodsize = productsize;
 
                                p1 = productsize + inner5 - 1;  //5' of outer primer
                                p2 = p1 - primersize;           //3' of primer
                                String tempstr = sequence.substring(p2, p1);
                                designPrimer design = new designPrimer();
                                outer = design.getReverse(tempstr);
			    }
			    if (p2 < sloc)
				break;	//snp would not be within the product
		        }
        	        else 
		        {
                            //check whether productsize out of source sequence range
                            if (productsize >= inner5)
                                break;
                            else
                            {
                                //save current productsize
                                prevprodsize = productsize;
 
                                p1 = inner5 - productsize - 1;  //5' of outer primer
                                p2 = p1 + primersize;           //3' of primer
                                outer = sequence.substring(p1, p2);
		            }
                        }
 
                        if (outer.length() !=0)
                        {
                            baseList seq = new baseList();
                            for (int i=0; i<primersize; i++)
                                seq.append(outer.charAt(i));

                            //check gc content
                            gc = (seq.num_GC * 100) / seq.num;
                            if ((gc >= minprimergc) && (gc <= maxprimergc))
                            {
                                gcOK = true;
                                //check melting temperature
                                delta_H = seq.delta_H * -1000.0;
                                delta_S = seq.delta_S * -1.0;
                                tm = (int)(delta_H / (delta_S + 1.987 * Math.log(primerconc/4000000000.0)) - 273.15 + 16.6 * Math.log(saltconc/1000.0) / Math.log(10));
 
                                //Tm should be between maxprimerTm and minprimerTm
                                if ((tm <= maxprimerTm) && (tm >= minprimerTm))
                                {
                                    tmOK = true;
                                    OK = true;
                                }
                                else
                                    OK = false;
                            }
                            else
                                OK = false;

                            //check complementarity
                            if (OK == true)
                            {
                                checkPrimer check = new checkPrimer();
                                valself = check.evalself(outer);
                                if (valself <= maxprimercom)
                                {
                                    val3self = check.eval3self(outer);
                                    if (val3self <= maxprimer3com)
                                    {
                                        valbtw = check.evalbtw(inner, outer);
                                        if (valbtw <= maxprimercom)
                                        {
                                            valOK = true;
                                            val3btw = check.eval3btw(inner, outer);
                                            if (val3btw <= maxprimer3com)
                                            {
                                                val3OK = true;
                                                OK = true;
                                            }
                                            else
                                                OK = false;
                                        }
                                        else
                                            OK = false;
                                    }
                                    else
                                        OK = false;
                                }
                                else
                                    OK = false;
                            }
 
                            if (OK == true)
                            {
                                primerEntry entry1 = new primerEntry(inner, innerTm, inner5, inner3);
                                primerEntry entry2;
				if (inner5 < sloc)
				    entry2 = new primerEntry(outer, tm, p1, (p2+1));
				else
				    entry2 = new primerEntry(outer, tm, (p1+1), p2);
				
                                primerPairEntry pairEntry = new primerPairEntry(entry1, entry2, optprimerTm);
                                ppl.insert(pairEntry);

                                countout++;

				//check whether the primer is an ideal one
				if (tm == innerTm) idealcount++;
                            }
                        } //end of if outer ...

                        count2--;
                    } //end of while count2 ...

                    count1--;
                } //end of while count1
  	    } //end of else
        } //end of outer while

        lock4.put("finish");
	return;

    } //end of run()
}
