//find where the introduced mismatch locates in the recognition sequence

import java.util.*;

public class misrecog
{
    private String seq = "";           	//the source sequence
    private String recogseq = "";       //the recognition sequence
    private String allele = "";
    private int sloc = 0;
    private int misloc = 0;

    public misrecog (String s1, String s2, String s3, int p1, int p2)
    {
        seq = s1;
        recogseq = s2;
	allele = s3;
        sloc = p1;
        misloc = p2;
    }

    //a method to check whether two nucleotides match each other
    private boolean checknt (char ch1, char ch2)
    {
        //ch1 is allele in source, ch2 is allele in recognition sequence
        if (ch1 == 'A')
        {
            if ((ch2 == 'A') || (ch2 == 'R') || (ch2 == 'H') ||
                (ch2 == 'V') || (ch2 == 'N') || (ch2 == 'M') ||
                (ch2 == 'W') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'T')
        {
            if ((ch2 == 'T') || (ch2 == 'K') || (ch2 == 'H') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'B') ||
                (ch2 == 'W') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'G')
        {
            if ((ch2 == 'G') || (ch2 == 'R') || (ch2 == 'K') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'S') ||
                (ch2 == 'B') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'C')
        {
            if ((ch2 == 'C') || (ch2 == 'H') || (ch2 == 'V') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'S') ||
                (ch2 == 'B') || (ch2 == 'M'))
                return true;
        }

        return false;
    }

    //a method to find the mismatch in the recognisiton sequence
    public int anchormis()
    {
	int len1 = recogseq.length();
	int len2 = 0;
	int len3 = 0;
	int p1 = 0;
	int p2 = 0;
	int misp = -1;
	String tempseq = "";
	String temp = "";

	if (misloc > sloc)
	{
	    len2 = misloc - sloc + 1;
	    len3 = len1 - len2;
	    //work out the possible range of recogseq around mismatch and polymorphism
	    if (len3 < 0)
	    {
	    	p1 = misloc - len1;
	    	p2 = misloc + len1;
	    }
	    else
	    {
	    	p1 = sloc - len3;
	    	p2 = misloc + len3;
	    }
	
	    tempseq = seq.substring(p1-1, p2);
	    //check recogseq from the start of tempseq
            for (int i=0; i<=len3; i++)
            {
	    	if (i == len3)
		    temp = tempseq.substring(i);
	    	else
		    temp = tempseq.substring(i, len1+i);

		int tmp = 0;
	    	for (int j=0; j<len1; j++)
	    	{
                    if (checknt(temp.charAt(j), recogseq.charAt(j)) == false)
		    {
			tmp = -1;
                    	break;
		    }
		}

		if (tmp != -1)
		{
		    misp = len1 - i;
		    break;
		}
	    }
	}
	else if (misloc < sloc)
	{
	    len2 = sloc - misloc + 1;
	    len3 = len1 - len2;
	    //work out the possible range of recogseq around mismatch and polymorphism
	    if (len3 < 0)
	    {
	    	p1 = sloc - len1 + 1;
	    	p2 = misloc + len1;
	    }
	    else
	    {
	    	p1 = misloc - len3;
	    	p2 = sloc + len3;
	    }
	    tempseq = seq.substring(p1-1, p2);
	    //check recogseq from the start of tempseq
            for (int i=0; i<=len3; i++)
            {
	    	if (i == len3)
		    temp = tempseq.substring(i);
	    	else
		    temp = tempseq.substring(i, len1+i);

		int tmp = 0;
	    	for (int j=0; j<len1; j++)
	    	{
                    if (checknt(temp.charAt(j), recogseq.charAt(j)) == false)
		    {
			tmp = -1;
                    	break;
		    }
		}

		if (tmp != -1)
		{
		    misp = len3 - i + 1;
		    break;
		}
	    }
	}

        return misp;
    }
}
