//get all possible mismatches according to inputs

import java.util.*;

public class mismatchseq
{
    private String seq = "";          //the wild-type source sequence
    private String allele1 = "";       //sequence of allele1
    private int sloc = 0;
    private int bpwidth = 0;           //the number of nucleotides to give mismatches
    private Stack stack = new Stack();
    private Stack temp = new Stack();

    public mismatchseq (String s1, String s2, int p1, int p2)
    {
        seq = s1;
	allele1 = s2;
        sloc = p1;
        bpwidth = p2;
    }

    //a method to return all mismatches for a particular nucleotide
    private String mismatch (char ch)
    {
        //assume that mismatches introduced only with A, T, C, G
        if (ch == 'A') 
            return "GCT";

        else if (ch == 'T')
            return "GCA";

        else if (ch == 'G')
            return "TCA";

        else if (ch == 'C')
            return "GAT";

        return "";
    }

    //a method to create the mismatch sequences
    public void mismatching ()
    {
         //first save the unchanged sequence into stack
         temp.push(java.lang.Integer.toString(sloc));

         //starting from the second before polymorphism
         for (int i=0; i<bpwidth; i++)
         {
             int misp = sloc - 3 - i;
             String mismatchstr = mismatch(seq.charAt(misp));
             if (mismatchstr != "")
             {
                 for (int j=0; j<mismatchstr.length(); j++)
                 {
                     //to save memory, only mismatch and positons are passed back
                     String tempseq = "";
                     tempseq += mismatchstr.charAt(j);                //introducing mismatch
                     tempseq += " ";
                     tempseq += java.lang.Integer.toString(misp+1);   //position of mismatch

                     temp.push(tempseq);
                 }
             } 
         }

         //starting from the second after polymorphism - allele1
         for (int i=0; i<bpwidth; i++)
         {
             int misp = sloc + allele1.length() + i;
             String mismatchstr = mismatch(seq.charAt(misp));
             if (mismatchstr != "")
             {
                 for (int j=0; j<mismatchstr.length(); j++)
                 {
                     //to save memory, only mismatch and positons are passed back
                     String tempseq = "";
                     tempseq += mismatchstr.charAt(j);                //introducing mismatch
                     tempseq += " ";
                     tempseq += java.lang.Integer.toString(misp+1);   //position of mismatch

                     temp.push(tempseq);
                 }
             } 
         }

         //reverse the order to stack content
         while (temp.empty() != true)
             stack.push(temp.pop());
    }

    //a method to get all potential cutting positions one by one
    public String get()
    {
        String tempstr = "";
        if (stack.empty() != true)
        {
            tempstr = (String)stack.pop();
            return tempstr;
        }
        else return null;
    }
}
