import java.util.*;

public class matchseq
{
    private String seq1 = "";           //the source sequence
    private String seq2 = "";           //the mutated source sequence
    private String recogseq = "";       //the recognition sequence
    private String allele1 = ""; 
    private String allele2 = "";
    private int sloc = 0;
    private int misloc = 0;

    public matchseq (String s1, String s2, String s3, String s4, int p1, int p2)
    {
        seq1 = s1;
        recogseq = s2;
        allele1 = s3;
        allele2 = s4;
        sloc = p1;
        misloc = p2;
	seq2 = s1.substring(0, sloc-1) + allele2 + s1.substring(sloc+allele1.length()-1);
    }

    //a method t0 check whether two nucleotides match each other
    private boolean checknt (char ch1, char ch2)
    {
        //ch1 is allele in source, ch2 is allele in recognition sequence
        if (ch1 == 'A')
        {
            if ((ch2 == 'A') || (ch2 == 'R') || (ch2 == 'H') ||
                (ch2 == 'V') || (ch2 == 'N') || (ch2 == 'M') ||
                (ch2 == 'W') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'T')
        {
            if ((ch2 == 'T') || (ch2 == 'K') || (ch2 == 'H') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'B') ||
                (ch2 == 'W') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'G')
        {
            if ((ch2 == 'G') || (ch2 == 'R') || (ch2 == 'K') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'S') ||
                (ch2 == 'B') || (ch2 == 'D'))
                return true;
        }

        else if (ch1 == 'C')
        {
            if ((ch2 == 'C') || (ch2 == 'H') || (ch2 == 'V') ||
                (ch2 == 'Y') || (ch2 == 'N') || (ch2 == 'S') ||
                (ch2 == 'B') || (ch2 == 'M'))
                return true;
        }

        return false;
    }

    //a method to check whether the two sequences match each other
    private boolean checkseq (int allelep, int n1, int n2)
    {
        int p1 = 0;
        int p2 = 0;
	int len1 = 0;
	int len2 = 0;
	int len3 = 0;
	int len4 = recogseq.length();
	String s = "";
	String allele = "";
        boolean mismatchIn = false;

	if (allelep == 1)
	{
	    s = seq1;
	    allele = allele1;
	}
	else
	{
	    s = seq2;
	    allele = allele2;
	}
	len1 = s.length();
	len2 = allele.length();
	len3 = len2 - allele1.length();	
	
        //move backwards and compare one by one
        for (int i=1; i<=n1 && i<sloc; i++)
        {
            p1 = sloc + n2 - i - 2;
            p2 = n1 - i;
            if (checknt(s.charAt(p1), recogseq.charAt(p2)) == false)
                return false;
            else if ((misloc < sloc) && (p1 == misloc - 1))		//misloc can only ahead polymorphism site here
                mismatchIn = true;
        }

        //move forwards and compare one by one
        for (int i=0; i<(len1-sloc-n2) && i<(len4-n1-1); i++)
        {
            p1 = sloc + n2 + i - 1;
            p2 = n1 + i + 1;
            if (checknt(s.charAt(p1), recogseq.charAt(p2)) == false)
                return false;
            else if ((misloc > sloc) && (p1 == misloc + len3 - 1))	//misloc can only after polymorphism site here
                mismatchIn = true;
        }

        //check whether mismatch contributes to the recogintion sequence
        if ((sloc != misloc) && (mismatchIn == false))
            return false;
        
        return true;
    }

    //a method to find the polymorphism in the recognisiton sequence
    //and to check whether the enzyme serves as a candidate
    public int anchorseq()
    {
        boolean allele1OK = false;
        boolean allele2OK = false;
	int len1 = seq1.length();
	int len2 = recogseq.length();
	int len3 = allele1.length();
	int len4 = allele2.length();

	//recogseq could begin one bp before or after allele1/allele2
	String temp1 = seq1.substring(sloc-2, sloc-1) + allele1 + seq1.substring(sloc+len3-1, sloc+len3);
	String temp2 = seq2.substring(sloc-2, sloc-1) + allele2 + seq2.substring(sloc+len4-1, sloc+len4);
	len3 = temp1.length();
	len4 = temp2.length();

        for (int i=0; i<len2; i++)
        {
	    for (int j=0; (j<len3) || (j<len4); j++)
	    {
            	if ((allele1OK == false) && (len3 > j) && checknt(temp1.charAt(j), recogseq.charAt(i)))
            	{
                    if (checkseq(1, i, j) == true)	//check seq1/allele1
                    	allele1OK = true;
            	}

            	if ((allele2OK == false) && (len4 > j) && checknt(temp2.charAt(j), recogseq.charAt(i)))
            	{
                    if (checkseq(2, i, j) == true) 	//check seq2/allele2
                    	allele2OK = true;
            	}

		if ((allele1OK) && (allele2OK))
		    return -1;		//not a good recognition sequence
	    }
        }

        if (allele1OK == true)
            return 1;
        else if (allele2OK == true)
            return 2;
        else
            return -1;
    }
}
