import java.io.*;
import java.util.*;

public class listEnzyme extends Thread
{
    private Lock1 lock1_2;
    private Lock1 lock2_1;
    private String seqline = "";         //source sequence
    private String allele1 = "";         //first allele in sequence
    private String allele2 = "";         //second allele in sequence
    private int sloc = 0;                //starting position of polymorphism in sequence
    private int optproductsize = 0;      //optimum primer size
    private int maxproductsize = 0;      //maximum primer size
    private int minproductsize = 0;      //minimum primer size
    private int bpwidth = 0;             //number of positions for mismatches on either side of SNP
    private int numsite = 0;    	 //number of restriction sites requested

    public listEnzyme (Lock1 l1, Lock1 l2, String s, String a1, String a2, int loc, int optprosize, int maxprosize, int minprosize, int numbp, int numsit)
    {
        lock1_2 = l1;
        lock2_1 = l2;
        seqline = s;
        allele1 = a1;
        allele2 = a2;
        sloc = loc;
        optproductsize = optprosize;
        maxproductsize = maxprosize;
        minproductsize = minprosize;
	bpwidth = numbp;
	numsite = numsit;
    }

    public void run()
    {
        String infile = "/export/home/xiayi/primer2/type2seq.out";
        Stack stack = new Stack();
        Stack tempStack = new Stack();

        try {
	    int recogcount = 0;		//count of recognition sites being chosed
            String thisline = "";
            String misline = "";
            String sequence = "";
            String recogseq = "";       //recognition sequence
            String positions = "";      //cutting positions
            String cutseq = "";         //the sequence (wild-type or mutant) where the cutting is introduced
            DataInputStream dis = new DataInputStream(new FileInputStream(infile));
            boolean found = false;
            boolean printentry = false;

            //save infile into stack
            while ((thisline = dis.readLine()) != null)
                tempStack.push(thisline);

            dis.close();

            //reverse to the right order
            while (tempStack.empty() != true) stack.push(tempStack.pop());

            //introduce various mismatches
            mismatchseq mms = new mismatchseq(seqline, allele1, sloc, bpwidth);
            mms.mismatching();    //do the trick

            while ((misline = mms.get()) != null)
            {
                String ch = "";
                int misp = 0;
                boolean printmisinfo = true;
                boolean printstarline = true;
 
                if (misline.equals(java.lang.Integer.toString(sloc)) == true)
                {
                    sequence = seqline;   //original
                    misp = sloc;          //means no mismatch
                }
                else
                {
                    StringTokenizer st = new StringTokenizer(misline);
                    ch = st.nextToken();
                    misp = java.lang.Integer.valueOf(st.nextToken()).intValue();

                    sequence = seqline.substring(0, misp-1);
                    sequence += ch;
                    sequence += seqline.substring(misp);
                }

                while (stack.empty() != true)
                {
                    thisline = (String)stack.pop();
                    //save data for later use
                    tempStack.push(thisline);

                    if (thisline.startsWith("Recognition") == true)
                    {
                        StringTokenizer st = new StringTokenizer(thisline);
                        recogseq = st.nextToken(); //actually "Recognition"
                        recogseq = st.nextToken(); //actually "sequence:"
                        recogseq = st.nextToken(); //that is it
                
                        matchseq mts = new matchseq(sequence, recogseq, allele1, allele2, sloc, misp);
			int allelep = mts.anchorseq();
                        if (allelep != -1)
                        {
			    if (recogcount == numsite)
			    {
				//requests satisfied, notify others and return
				lock1_2.put("finish");
		            	System.out.println("********************************************************************************");
				System.out.println("\nCompleted");
				return;
			    }

                            String tempseq = "";
                            if (allelep == 1)
			    {
                                tempseq = sequence;
				cutseq = "wild-type sequence";
			    }
                            else
                            {
                                tempseq = sequence.substring(0, sloc-1);
                                tempseq += allele2;
                                tempseq += sequence.substring(sloc+allele1.length()-1);
				cutseq = "mutant DNA";
                            }

                            matchwide mtw = new matchwide(seqline, tempseq, recogseq, allele1, allele2, sloc, misp, allelep);
			    int misloc = -1;
			    misloc = mtw.matching();
                            if (misloc != -1)
                            {
                                //print out what mismatch (only) once
                                if (printmisinfo == true)
                                {
		                    //print out a star line to terminate
		        	    if (printstarline)
		        	    {
		            	 	System.out.println("********************************************************************************");
		            		printstarline = false;
		        	    }

                                    System.out.println("");
				    if (misp == sloc) //no mismatch introduced
					System.out.println("No mismatch introduced");
				    else
                                    	System.out.println("Mismatch " + ch + " introduced at position " + misp + " of input sequence");
                                    System.out.println("\n");

				    printmisinfo = false;
			 	}

				System.out.println("\n---Restriction Analysis Entry " + ++recogcount + " (" + cutseq + ")" + "---\n");

                                //send the info out for primer design
                                lock1_2.put(recogseq + " " + java.lang.Integer.toString(misp) + " " + java.lang.Integer.toString(allelep) + " " + ch);
                                //wait for the feedback (content is not important)
                                lock2_1.get();

                                //indicate the mismatch position in the recognition sequence using symbol "*";
				if (misloc > 0)
				{
				    String temp = "Recognition sequence:";
				    int templen = temp.length();
				    templen += 1;		//count the space after before recogseq
				    templen += misloc;		//now the position of mismatch
				    temp = "";
				    for (int i=1; i<templen; i++)
					temp += " ";
				    temp += "*";
				    System.out.println(temp);
				}

                                //print out the recognition sequence
                                System.out.println(thisline);

                                String position = "";
                                positions = "Locations in " + cutseq + ": ";
                                while ((position = mtw.get()) != null)
                                {
                                    positions += position;
                                    positions += ", ";
                                }

                                //get ride of last ", "
                                positions = positions.trim();
                                positions = positions.substring(0, positions.length()-1);
   
                                found = true;
                                printentry = true;
                            }
                        }
                    }
                    else if ((thisline.startsWith("Enzymes:")) && (printentry))
                    {
                        //print out the position list, no more than 80 characters per line
			if (positions.length() <= 80)
                            System.out.println(positions);
			else
			{
			    String templine = positions;
			    while (templine.length() > 80)
			    {
				int p1 = 80;
				while (templine.charAt(p1-1) != ',')
				    p1--;
				System.out.println(templine.substring(0, p1));
				templine = templine.substring(p1);
			    }
			    System.out.println(templine);
			}

                        //print out the enzyme list, not more than 80 characters per line
			if (thisline.length() <= 80)
                            System.out.println(thisline);
			else
			{
			    String templine = thisline;
			    while (templine.length() > 80)
			    {
				int p1 = 80;
				while (templine.charAt(p1-1) != ',')
				    p1--;
				System.out.println(templine.substring(0, p1));
				templine = templine.substring(p1);
			    }
			    System.out.println(templine);
			}

			System.out.println("\n");
	
                        printentry = false;
                    }
                } //end of inner while

                //push back all entries to stack
                while (tempStack.empty() != true) stack.push(tempStack.pop());

            } //end of outer while

            if (found == false)
                System.out.println("No suitable enzymes found");
	    else if (recogcount < numsite)
	    {
		System.out.println("********************************************************************************");
		System.out.println("\nOnly " + recogcount + " restriction targets found");
	    }
	    else if (recogcount == numsite)
	    {
		System.out.println("********************************************************************************");
		System.out.println("\nCompleted");
	    }
                
        } //end of try
        catch (IOException e) { System.err.println(e); }

        lock1_2.put("finish");       //terminate all threads
        return;
    } //end of run
} //end
