//fine name: doPrimer.java, Done on 14 December 2000

import java.io.*;
import java.util.*;

public class doPrimer {

    static int InputCount = 22;      //expected number of inputs
    public static void main(String[] args) {

        String signal = "";          //signal to terminate program or not
        String seq = "";             //source sequence
        int sloc = 0;                //starting position of polymorphism in sequence
        String allele1 = "";         //first allele
        String allele2 = "";         //second allele
        int optprimersize = 0;       //optimum primer size
        int maxprimersize = 0;       //maximum primer size
        int minprimersize = 0;       //minimum primer size
        int optproductsize = 0;      //optimum product size
        int maxproductsize = 0;      //maximum product size
        int minproductsize = 0;      //minimum product size
        int optprimerTm = 0;         //optimum primer Tm
        int maxprimerTm = 0;         //maximum primer Tm
        int minprimerTm = 0;         //minimum primer Tm
        double maxprimergc = 0;      //maximum primer GC%
        double minprimergc = 0;      //minimum primer GC%
        double maxprimercom = 0;     //maximum primer complementarity
        double maxprimer3com = 0;    //maximum primer 3' complementarity
        double saltconc = 0;         //salt (K+) concentration in mM
        double primerconc = 0;       //primer concentration in nM
        int bpwidth = 0;             //number of positions for mismatches on either side of SNP
        int numsite = 0;             //number of restriction sites
        int numoutput = 0;           //number of outputs

        //work out the input values
        StringTokenizer st = new StringTokenizer(args[0]);
        int currentcount = st.countTokens();
        if (currentcount == InputCount)
        {
            String s = "";
            s = st.nextToken().toUpperCase();
            for (int i=0; i<s.length(); i++) 
            {
                //The program will treat '*', '-' as 'N'
                if ((s.charAt(i) == '*') || (s.charAt(i) == '-'))
                    seq += "N"; 

                //The program will treat 'A', 'T', 'C', 'G', 'R', 'K',
                //'H', 'D', 'Y', 'S', 'B', 'M', 'W', 'V', 'N' as it is 
                else if ((s.charAt(i) == 'A') || (s.charAt(i) == 'C') || 
                    (s.charAt(i) == 'G') || (s.charAt(i) == 'T') || 
                    (s.charAt(i) == 'R') || (s.charAt(i) == 'K') ||
                    (s.charAt(i) == 'H') || (s.charAt(i) == 'D') ||
                    (s.charAt(i) == 'Y') || (s.charAt(i) == 'S') ||
                    (s.charAt(i) == 'B') || (s.charAt(i) == 'M') ||
                    (s.charAt(i) == 'W') || (s.charAt(i) == 'V') ||
                    (s.charAt(i) == 'N')) 
                    seq += s.charAt(i); 
            }

            try {
                sloc = Integer.valueOf(st.nextToken()).intValue();
                allele1 = st.nextToken().toUpperCase();
                allele2 = st.nextToken().toUpperCase();
		if (allele1.equalsIgnoreCase("SPACE"))
		    allele1 = "";
		if (allele2.equalsIgnoreCase("SPACE"))
		    allele2 = "";				//return to the real space status
                optprimersize = Integer.valueOf(st.nextToken()).intValue();
                maxprimersize = Integer.valueOf(st.nextToken()).intValue();
                minprimersize = Integer.valueOf(st.nextToken()).intValue();
                optproductsize = Integer.valueOf(st.nextToken()).intValue();
                maxproductsize = Integer.valueOf(st.nextToken()).intValue();
                minproductsize = Integer.valueOf(st.nextToken()).intValue();
                optprimerTm = Integer.valueOf(st.nextToken()).intValue();
                maxprimerTm = Integer.valueOf(st.nextToken()).intValue();
                minprimerTm = Integer.valueOf(st.nextToken()).intValue();
                maxprimergc = Double.valueOf(st.nextToken()).doubleValue();
                minprimergc = Double.valueOf(st.nextToken()).doubleValue();
                maxprimercom = Double.valueOf(st.nextToken()).doubleValue();
                maxprimer3com = Double.valueOf(st.nextToken()).doubleValue();
                saltconc = Double.valueOf(st.nextToken()).doubleValue();
                primerconc = Double.valueOf(st.nextToken()).doubleValue();
                bpwidth = Integer.valueOf(st.nextToken()).intValue();
                numsite = Integer.valueOf(st.nextToken()).intValue();
                numoutput = Integer.valueOf(st.nextToken()).intValue();
            }
            catch (NumberFormatException e)
            {
                System.err.println(e);
                return;
            }
        }
        else
        {
            System.out.println("Only " + currentcount + " out of " + InputCount + " inputs - Abort!");
            return;
        }

        //validate the input sequence: 1) sloc should be greater than input
        //sequence length. 2) Allele 1 should be the same as the Nucleotides as
        //indicated by sloc in the sequence. 3) at least minimum primer size before sloc.
        //4) at least minimum primer size after the sloc location. 5) at least
        //minproduct size of the sequence size

        if (sloc >= seq.length())
        {
            System.out.println("Polymorphism position outside of input sequence - Abort");
            return;
        }
        else if (sloc < minprimersize + 1)
        {
            System.out.println("Unable to find a forward primer");
            return;
        }
        else if (seq.length() - sloc - 1 < minprimersize)
        {
            System.out.println("Unable to find a reverse primer");
            return;
        }
        else if (seq.length() < minproductsize)
        {
            System.out.println("Product size between forward and reverse primers");
            System.out.println("would have to be shorter than input minimum product size");
            return;
        }
        else if ((allele1.length() != 0) && (allele1.equalsIgnoreCase(seq.substring(sloc-1, sloc+allele1.length()-1)) != true))
        {
            System.out.println("Allele 1 not agree with allele in input sequence");
            System.out.println("Allele in sequence is " + seq.substring(sloc, sloc+allele1.length())); 
            System.out.println("Allele 1 is " + allele1); 
            return;
        }
	else if ((allele1.length() == 0) && (allele2.length() == 0))
	{
            System.out.println("Both alleles undefined!");
            return;
        }
        else if (allele1.equalsIgnoreCase(allele2))
        {
            System.out.println("The same allele in allele inputs!");
            System.out.println("Allele 1 is " + allele1); 
            System.out.println("Allele 2 is " + allele2); 
            return;
        }
        else if (maxprimersize < minprimersize)
        {
            System.out.println("Maximum primer size shorter than minimum size in input!");
            return;
        }
        else if (maxprimersize < optprimersize)
        {
            System.out.println("Maximum primer size shorter than optimum size in input!");
            return;
        }
        else if (minprimersize > optprimersize)
        {
            System.out.println("Minimum primer size longer than optimum size in input!");
            return;
        }
        else if (maxproductsize < minproductsize)
        {
            System.out.println("Maximum product size shorter than minimum size in input!");
            return;
        }
        else if (maxproductsize < optproductsize)
        {
            System.out.println("Maximum product size shorter than optimum size in input!");
            return;
        }
        else if (minproductsize > optproductsize)
        {
            System.out.println("Minimum product size longer than optimum size in input!");
            return;
        }
        else if (maxprimerTm < minprimerTm)
        {
            System.out.println("Maximum primer Tm lower than minimum Tm in input!");
            return;
        }
        else if (maxprimerTm < optprimerTm)
        {
            System.out.println("Maximum primer Tm lower than optimum Tm in input!");
            return;
        }
        else if (minprimerTm > optprimerTm)
        {
            System.out.println("Minimum primer Tm higher than optimum Tm in input!");
            return;
        }
        else if (minprimergc > maxprimergc)
        {
            System.out.println("Minimum primer GC% larger than maximum GC% in input!");
            return;
        }
        else if (bpwidth > 14)
        {
            //usually unnecessary and also a nuisance to the server
            System.out.println("Too many positions allowed for mismatches!");
            return;
        }
        else if (numoutput > 100)
        {
            //usually unnecessary and also a nuisance to the server
            System.out.println("Too many primer pairs requested!");
            return;
        }
        
        Lock1 l1_2 = new Lock1(); 
        Lock1 l2_1 = new Lock1(); 
        Lock1 l2_3 = new Lock1(); 
        Lock1 l4 = new Lock1(); 

        listEnzyme listenzyme = new listEnzyme(l1_2, l2_1, seq, allele1, allele2, sloc, optproductsize, maxproductsize, minproductsize, bpwidth, numsite);
        snpPrimer snpprimer = new snpPrimer(l1_2, l2_1, l2_3, seq, allele1, allele2, sloc, optprimersize, maxprimersize, minprimersize, maxproductsize, minproductsize, optprimerTm, maxprimerTm, minprimerTm, maxprimergc, minprimergc, maxprimercom, maxprimer3com, saltconc, primerconc);
        outerPrimer outerprimer = new outerPrimer(l2_1, l2_3, l4, seq, allele1, allele2, sloc, optprimersize, maxprimersize, minprimersize, optproductsize, maxproductsize, minproductsize, optprimerTm, maxprimerTm, minprimerTm, maxprimergc, minprimergc, maxprimercom, maxprimer3com, saltconc, primerconc, numoutput);

        listenzyme.start();
        snpprimer.start();
        outerprimer.start();

        signal = l4.get();
        if (signal.equalsIgnoreCase("finish"))
            return; 
    }
}
