import java.io.*;
import java.util.*;

public class buildTable
{
    static String infile = "/export/home/xiayi/snpcut/type2.seq";
    static String outfile = "/export/home/xiayi/snpcut/type2seq.out";
    static Stack stack1 = new Stack();
    static Stack stack2 = new Stack();
    static Stack temp = new Stack();
    static int field1 = 30;          //field 1 width
    static int field2 = 25;          //field 2 width

    static void main (String[] args)
    {
        try {
            String thisline = "";
            String recogseq = "";       //recognition sequence
            String enzymes = "";        //names of enzymes
            DataInputStream dis = new DataInputStream(new FileInputStream(infile));
            PrintStream ps = new PrintStream(new FileOutputStream(outfile));
            boolean begin = false;

            //first save the info into the stacks
            while ((thisline = dis.readLine()) != null)
            {
                if (thisline.indexOf("**********") != -1)
                    begin = true;
 
                if ((begin == true) && (thisline.indexOf("**********") == -1))
                {
                    //the first stack contains all entries
                    stack1.push(thisline);

                    //the second stack only contains unique sequences
                    recogseq = thisline.substring(0, field1).toUpperCase().trim();

                    if (stack2.search(recogseq) == -1)
                        stack2.push(recogseq);
                }
            }

            //put the order right
            while (stack1.empty() != true) temp.push(stack1.pop());
            while (temp.empty() != true) stack1.push(temp.pop());
            while (stack2.empty() != true) temp.push(stack2.pop());
            while (temp.empty() != true) stack2.push(temp.pop());
             
            //start to work from stack2
            while (stack2.empty() != true)
            {
                thisline = (String)stack2.pop();

                //print out the recognition sequence
                System.out.println("Recognition sequence: " + thisline);
                ps.println("Recognition sequence: " + thisline);

                //create stack to store similar enzymes
                Stack enzymeStack = new Stack();

                //check the full stack for similar enzymes
                while (stack1.empty() != true)
                {
                    String templine = (String)stack1.pop();
                    //save templine for later uses
                    temp.push(templine);

                    String s1 = templine.substring(0, field1).toUpperCase().trim();
                    String s2 = templine.substring(field1, field1+field2).toUpperCase().trim();

                    if (s1.equalsIgnoreCase(thisline))
                    {
                         //the same recognition sequence
                         //save enzymes to stack
                         StringTokenizer st = new StringTokenizer(s2);
                         while (st.hasMoreTokens())
                         {
                             String tempstr = st.nextToken();
                             if (tempstr.endsWith(","))
                                 tempstr = tempstr.substring(0, tempstr.length()-1);

                             if (enzymeStack.search(tempstr) == -1)
                                 enzymeStack.push(tempstr);
                         }
                    }
                }
            
                String temps = "";
                while (enzymeStack.empty() != true)
                {
                    temps += (String)enzymeStack.pop();
                    temps += ", ";
                }

                //get ride of last ", "
                temps = temps.trim();
                temps = temps.substring(0, temps.length()-1);

                //print out heading first
                System.out.print("Enzymes: ");
                ps.print("Enzymes: ");

                //print out the list of enzymes
                System.out.print(temps);
                ps.print(temps);

                //print out a new line to terminate
                System.out.println("");
                ps.println("");

                //push back all entries to stack1 and in right order
                while (temp.empty() != true) stack1.push(temp.pop());

            } //end of while
 
            //close streams cleanly   
            dis.close();
            ps.close();

        } //end of try

        catch (IOException e) { System.err.println(e); }

    } //end of main
} //end
