import java.io.*;

public class buildDB
{
    static String infile = "/export/home/xiayi/snpcut/type2.012";
    static String outfile = "/export/home/xiayi/snpcut/type2.seq";
    static String heading1 = "Sequence";
    static String heading2 = "Enzymes";
    static String heading3 = "cutting infomation";
    static String starline = "*******************************************************************************************";
    static int field1 = 30;
    static int field2 = 25;

    static void main (String[] args)
    {
        try {
            String thisline = "";
            String padding1 = "";
            String padding2 = "";
            String sequence = "";
            String enzyme = "";
            String info = "";

            DataInputStream dis = new DataInputStream(new FileInputStream(infile));
            PrintStream ps = new PrintStream(new FileOutputStream(outfile));

            //print headings first
            for (int i=0; i<(field1-heading1.length()); i++)
                 padding1 += " ";
            for (int i=0; i<(field2-heading2.length()); i++)
                 padding2 += " ";

            ps.println(heading1 + padding1 + heading2 + padding2 + heading3);
            ps.println(starline);
            System.out.println(heading1 + padding1 + heading2 + padding2 + heading3);
            System.out.println(starline);

            while ((thisline = dis.readLine()) != null)
            {
                thisline = thisline.trim();

                if ((thisline.startsWith("<1>")) && (thisline.equals("<1>") != true))
                    enzyme = enzyme + thisline.substring(3) + ", ";
                if ((thisline.startsWith("<2>")) && (thisline.equals("<2>") != true))
                    enzyme += thisline.substring(3);

                if ((thisline.startsWith("<3>")) && (thisline.equals("<3>") != true))
                {
                    info = thisline.substring(3);
                    for (int i=0; i<info.length(); i++)
                    {
                        char ch = info.charAt(i);
                        if (Character.isLetter(ch))
                            sequence += ch;
                    }
                    sequence = sequence.toUpperCase();

                    padding1 = "";
                    padding2 = "";
                    for (int i=0; i<(field1-sequence.length()); i++)
                         padding1 += " ";
                    for (int i=0; i<(field2-enzyme.length()); i++)
                         padding2 += " ";
                 
                    if ((sequence.charAt(0) != '<') &&
                        (enzyme.charAt(0) != '<') &&
                        (info.charAt(0) != '<'))
                    { 
                        ps.println(sequence + padding1 + enzyme + padding2 + info);
                        System.out.println(sequence + padding1 + enzyme + padding2 + info);
                    }
                    
                    sequence = "";
                    enzyme = "";
                    info = "";
                }
            } //end of while
        } //end of try
        catch (IOException e) { System.err.println(e); }

    } //end of main
} //end
